/*
Copyright (c) 2005, Jason Terando
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the parties distributing the library nor the names of its contributors may be
      used to endorse or promote products derived from this software without
      specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#pragma once

[import(".\\ForwardDefs.idl")];

[
	export,
	v1_enum,
	uuid("65BB3F87-9AC8-456e-BB0B-3C8034FD1371"),
	helpcontext(0101)
]
enum SkypeAPIAttachmentStatus {
	[helpcontext(0101), helpstring("Unknown")] apiAttachUnknown = -1,
	[helpcontext(0101), helpstring("Success")] apiAttachSuccess = 0,
	[helpcontext(0101), helpstring("Pending Authorization")] apiAttachPendingAuth = 1,
	[helpcontext(0101), helpstring("Refused")] apiAttachRefused = 2,
	[helpcontext(0101), helpstring("Not Available")] apiAttachNotAvailable = 3,
	[helpcontext(0101), helpstring("API Available")] apiAttachAPIAvail = 0x8001
};

[
	export,
	v1_enum,
	uuid("8FCBDB89-66FF-4638-ABB2-CD9B41CE70D7"),
	helpcontext(0102)
]
enum SkypeConnectionStatus {
	[helpcontext(0102), helpstring("Unknown")] conUnknown = -1,
	[helpcontext(0102), helpstring("Offline")] conOffline = 0,
	[helpcontext(0102), helpstring("Connecting")] conConnecting = 1,
	[helpcontext(0102), helpstring("Pausing")] conPausing = 2,
	[helpcontext(0102), helpstring("Online")] conOnline = 3,
	[helpcontext(0102), helpstring("LoggedOut")] conLoggedOut = 4
};

[
	export,
	v1_enum,
	uuid("A92E0B9F-DAF6-4092-A772-E920FEDDCCE9"),
	helpcontext(0103)
]
enum SkypeCallProgress {
	[helpcontext(0103), helpstring("Unknown call status")] prgUnknown = -1,
	[helpcontext(0103), helpstring("Call was never placed")] prgUnplaced = 0,
	[helpcontext(0103), helpstring("Call is currently being routed")] prgRouting = 1,
	[helpcontext(0103), helpstring("Early media is being played")] prgEarlyMedia = 2,
	[helpcontext(0103), helpstring("Call Failed")] prgFailed = 3,
	[helpcontext(0103), helpstring("Ringing")] prgRinging = 4,
	[helpcontext(0103), helpstring("Call is in progress")] prgInProgress = 5,
	[helpcontext(0103), helpstring("Call is placed on hold")] prgOnHold = 6,
	[helpcontext(0103), helpstring("Call is finished")] prgFinished = 7,
	[helpcontext(0103), helpstring("Call was missed")] prgMissed = 8,
	[helpcontext(0103), helpstring("Call was refused")] prgRefused = 9,
	[helpcontext(0103), helpstring("Destination is busy")] prgBusy = 10,
	[helpcontext(0103), helpstring("Call was cancelled")] prgCancelled = 11,
	[helpcontext(0103), helpstring("Call was placed on hold remotely")] prgRemoteHold = 12,
	[helpcontext(0103), helpstring("Call was placed on hold locally")] prgLocalHold = 13,
	[helpcontext(0103), helpstring("Buffering Greeting")] prgBufferingGreeting = 14,
	[helpcontext(0103), helpstring("Playing Greeting")] prgPlayingGreeting = 15,
	[helpcontext(0103), helpstring("Recording VoiceMail")] prgRecordingVoiceMail = 16,
	[helpcontext(0103), helpstring("Uploading VoiceMail")] prgUploadingVoiceMail = 17,
	[helpcontext(0103), helpstring("Sent VoiceMail")] prgSentVoiceMail = 18,
	[helpcontext(0103), helpstring("Cancelled VoiceMail")] prgCancelledVoiceMail = 19,
	[helpcontext(0103), helpstring("Failed VoiceMail")] prgFailedVoiceMail = 20
};

[
	export,
	v1_enum,
	uuid("3859796A-5B13-4400-80B2-254516AEC067"),
	helpcontext(0104)
]
enum SkypeCallType {
	[helpcontext(0104), helpstring("Unknown call type")] ctypUnknown = -1,
	[helpcontext(0104), helpstring("Incoming PSTN")] ctypIncomingPSTN = 0,
	[helpcontext(0104), helpstring("Outgoing PSTN")] ctypOutgoingPSTN = 1,
	[helpcontext(0104), helpstring("Incoming P2P")] ctypIncomingP2P = 2,
	[helpcontext(0104), helpstring("Outgoing P2P")] ctypOutgoingP2P = 3
};

[
	export,
	v1_enum,
	uuid("33C4110A-02D8-4092-AC69-B7B258786762"),
	helpcontext(0105)
]
enum SkypeMessageType {
	[helpcontext(0105), helpstring("Unknown message type")] mtypUnknown = -1,
	[helpcontext(0105), helpstring("Authorization Request")] mtypAuthRequest = 0,
	[helpcontext(0105), helpstring("Text")] mtypText = 1,
	[helpcontext(0105), helpstring("Contacts")] mtypContacts = 2
};

[
	export,
	v1_enum,
	uuid("D6E5321C-982A-4470-9F50-D5E97280D2E0"),
	helpcontext(0106)
]
enum SkypeMessageStatus {
	[helpcontext(0106), helpstring("Unknown message status")] msgUnknown = -1,
	[helpcontext(0106),helpstring("Message is being sent")] msgSending = 0,
	[helpcontext(0106),helpstring("Message was sent")] msgSent = 1,
	[helpcontext(0106),helpstring("Mesasge sending failed")] msgFailed = 2,
	[helpcontext(0106),helpstring("Message has been received")] msgReceived = 3,
	[helpcontext(0106),helpstring("Message has been read")] msgRead = 4,
	[helpcontext(0106),helpstring("Message was ignored")] msgIgnored = 5,
	[helpcontext(0106),helpstring("Message is queued")] msgQueued = 6
};

[
	export,
	v1_enum,
	uuid("127D4942-E520-4cfc-B5FD-B2FDFBA98782"),
	helpcontext(0107)
]
enum SkypeUserSex {
	[helpcontext(0107), helpstring("Unknown")] usexUnknown = -1,
	[helpcontext(0107), helpstring("Not Sepcified")] usexNotSpecified = 0,
	[helpcontext(0107), helpstring("Male")] usexMale = 1,
	[helpcontext(0107), helpstring("Femail")] usexFemale = 2
};

[
	export,
	v1_enum,
	uuid("1D72D739-69FB-48b0-9D2D-E9FA0E1108AE"),
	helpcontext(0108)
]
enum SkypeBuddyStatus {
	[helpcontext(0108), helpstring("Unknown")] budUnknown = -1,
	[helpcontext(0108), helpstring("Never been in friendlist")] budNever = 0,
	[helpcontext(0108), helpstring("Deleted from friendlist")] budDeleted = 1,
	[helpcontext(0108), helpstring("Pending authorization")] budPending = 2,
	[helpcontext(0108), helpstring("Friend")] budFriend = 3
};

[
	export,
	v1_enum,
	uuid("BD1F7281-2E21-4d6c-993E-2C21B1114726"),
	helpcontext(0109)
]
enum SkypeOnlineStatus {
	[helpcontext(0109), helpstring("Unknown")] olsUnknown = -1,
	[helpcontext(0109), helpstring("Offline")] olsOffline = 0,
	[helpcontext(0109), helpstring("Online")] olsOnline = 1,
	[helpcontext(0109), helpstring("Away")] olsAway = 2,
	[helpcontext(0109), helpstring("Not Available")] olsNotAvail = 3,
	[helpcontext(0109), helpstring("Do Not Disturb")] olsDoNotDisturb = 4,
	[helpcontext(0109), helpstring("Invisible")] olsInvisible = 5,
	[helpcontext(0109), helpstring("SkypeMe")] olsSkypeMe = 6,
	[helpcontext(0109), helpstring("LoggedOut")] olsLoggedOut = 7
};

[
	export,
	v1_enum,
	uuid("8DD2EDDA-C8FE-4c37-8B49-FE04825C8206"),
	helpcontext(0110)
]
enum SkypeChatStatus {
	[helpcontext(0110), helpstring("Unknown")] chatUnknown = -1,
	[helpcontext(0110), helpstring("Legacy Dialog")] chatLegacyDialog = 0,
	[helpcontext(0110), helpstring("Dialog")] chatDialog = 1,
	[helpcontext(0110), helpstring("Multi Need Accept")] chatMultiNeedAccept = 2,
	[helpcontext(0110), helpstring("MultiSubscribed")] chatMultiSubscribed = 3
};

[
	export,
	v1_enum,
	uuid("5F10C769-6EF1-4495-9E12-B37ED9C311D4"),
	helpcontext(0111)
]
enum SkypeChatMessageStatus {
	[helpcontext(0111), helpstring("Unknown")] chatMsgUnknown = -1,
	[helpcontext(0111), helpstring("Sending")] chatMsgSending = 0,
	[helpcontext(0111), helpstring("Sent")] chatMsgSent = 1,
	[helpcontext(0111), helpstring("Received")] chatMsgReceived = 2,
	[helpcontext(0111), helpstring("Read")] chatMsgRead = 3
};

[
	export,
	v1_enum,
	uuid("2315D3E3-C08A-4a5d-8A87-5D9439DCBFFC"),
	helpcontext(0112)
]
enum SkypeChatMessageLeftReason {
	[helpcontext(0112), helpstring("Unknown")] chatMsgLeftUnknown = -1,
	[helpcontext(0112), helpstring("User Not Found")] chatMsgLeftUserNotFound = 0,
	[helpcontext(0112), helpstring("User Incapable")] chatMsgLeftUserIncapable = 1,
	[helpcontext(0112), helpstring("Adder Must Be Friend")] chatMsgLeftAdderMustBeFriend = 2,
	[helpcontext(0112), helpstring("Adder Must Be Authorized")] chatMsgLeftAdderMustBeAuthorized = 3,
	[helpcontext(0112), helpstring("Decline to Add")] chatMsgLeftDeclineAdd = 4,
	[helpcontext(0112), helpstring("Unsubscribe")] chatMsgLeftUnsubscribe = 5
};

[
	export,
	v1_enum,
	uuid("380437AD-6069-4a9f-B53F-9FDB9D7FF6C6"),
	helpcontext(0113)
]
enum SkypeCurrencyType {
	[helpcontext(0113), helpstring("Unknown")] currUnknown = -1,
	[helpcontext(0113), helpstring("EuroCents")] currEuroCents = 0
};

[
	export,
	v1_enum,
	uuid("D700390A-F14B-4275-9FF7-5E19802BEF3D"),
	helpcontext(0114)
]
enum SkypeChatMessageType {
	[helpcontext(0114), helpstring("Unknown")] chatMsgTypeUnknown = -1,
	[helpcontext(0114), helpstring("SetTopic")] chatMsgTypeSetTopic = 0,
	[helpcontext(0114), helpstring("Said")] chatMsgTypeSaid = 1,
	[helpcontext(0114), helpstring("AddedMembers")] chatMsgTypeAddedMembers = 2,
	[helpcontext(0114), helpstring("SawMembers")] chatMsgTypeSawMembers = 3,
	[helpcontext(0114), helpstring("CreatedChatWith")] chatMsgTypeCreatedChatWith = 4,
	[helpcontext(0114), helpstring("Left")] chatMsgTypeLeft= 5
};

[
	export,
	v1_enum,
	uuid("FCDD7B32-D901-4933-8C5D-1B380BDE3C96"),
	helpcontext(0115)
]
enum SkypeVoiceMailType {
	[helpcontext(0115), helpstring("Unknown")] vmTypeUnknown = -1,
	[helpcontext(0115), helpstring("Incoming")] vmTypeIncoming = 0,
	[helpcontext(0115), helpstring("Default Greeting")] vmTypeDefaultGreeting = 1,
	[helpcontext(0115), helpstring("Custom Greeting")] vmTypeCustomGreeting = 2,
	[helpcontext(0115), helpstring("Outgoing")] vmTypeOutgoing = 3
};

[
	export,
	v1_enum,
	uuid("0B7F55D7-ED68-4e09-91A4-0F20DB0E186F"),
	helpcontext(0116)
]
enum SkypeVoiceMailStatus {
	[helpcontext(0116), helpstring("Unknown")] vmStatusUnknown = -1,
	[helpcontext(0116), helpstring("Now Downloading")] vmStatusDownloading = 0,
	[helpcontext(0116), helpstring("Downloaded")] vmStatusDownloaded = 1,
	[helpcontext(0116), helpstring("Unplayed")] vmStatusUnplayed = 2,
	[helpcontext(0116), helpstring("Buffering")] vmStatusBuffering = 3,
	[helpcontext(0116), helpstring("Playing")] vmStatusPlaying = 4,
	[helpcontext(0116), helpstring("Played")] vmStatusPlayed = 5,
	[helpcontext(0116), helpstring("Blank")] vmStatusBlank = 6,
	[helpcontext(0116), helpstring("Recording")] vmStatusRecording = 7,
	[helpcontext(0116), helpstring("Recorded")] vmStatusRecorded = 8,
	[helpcontext(0116), helpstring("Uploading")] vmStatusUploading = 9,
	[helpcontext(0116), helpstring("Uploaded")] vmStatusUploaded = 10,
	[helpcontext(0116), helpstring("Deleting")] vmStatusDeleting = 11,
	[helpcontext(0116), helpstring("Failed")] vmStatusFailed = 12
};

[
	export,
	v1_enum,
	uuid("57181448-1317-411c-B064-6F2E872F3BC0"),
	helpcontext(0117)
]
enum SkypeVoiceMailFailure {
	[helpcontext(0117), helpstring("Unknown")] vmFailureUnknown = -1,
	[helpcontext(0117), helpstring("Miscellaneous Error")] vmFailureMisc = 0,
	[helpcontext(0117), helpstring("Connection Error")] vmFailureConnect = 1,
	[helpcontext(0117), helpstring("No VoiceMail Privilege")] vmFailureNoPrivilege = 2,
	[helpcontext(0117), helpstring("No Such VoiceMail")] vmFailureNoSuchVoiceMail = 3,
	[helpcontext(0117), helpstring("File Read Error")] vmFailureReadError = 4,
	[helpcontext(0117), helpstring("File Write Error")] vmFailureWriteError = 5,
	[helpcontext(0117), helpstring("Recording Error")] vmFailureRecording = 6,
	[helpcontext(0117), helpstring("Playbck Error")] vmFailurePlayback = 7
};

[
	export,
	v1_enum,
	uuid("4D1434DB-6F9F-4533-ACAF-B712F9F54F81"),
	helpcontext(0118)
]
enum SkypeClearCallHistory {
	[helpcontext(0118), helpstring("All")] clrAllCalls = 0,
	[helpcontext(0118), helpstring("Missed")] clrMissedCalls = 1,
	[helpcontext(0118), helpstring("Incoming")] clrIncomingCalls = 2,
	[helpcontext(0118), helpstring("Outgoing")] clrOutgoingCalls = 3
};

[
	export,
	v1_enum,
	uuid("A3678CC3-AC6E-4ffb-A8B5-FA57B97D4BF4"),
	helpcontext(0119)
]
enum SkypeNoAnswerAction {
	[helpcontext(0119), helpstring("Unknown")] noAnsUnknown = -1,
	[helpcontext(0119), helpstring("Reject")] noAnsReject = 0,
	[helpcontext(0119), helpstring("Forward")] noAnsForward = 1,
	[helpcontext(0119), helpstring("Voicemail")] noAnsVoicemail = 2
};

[
	export,
	v1_enum,
	uuid("EEC83F5F-3413-4c9e-BACA-295A76125CD8"),
	helpcontext(0120)
]
enum SkypeOptionsPage {
	[helpcontext(0120), helpstring("General")] pgGeneral = 0,
	[helpcontext(0120), helpstring("Privacy")] pgPrivacy = 1,
	[helpcontext(0120), helpstring("Notificaitons")] pgNotifications = 2,
	[helpcontext(0120), helpstring("SoundAlerts")] pgSoundAlerts = 3,
	[helpcontext(0120), helpstring("SoundDevices")] pgSoundDevices = 4,
	[helpcontext(0120), helpstring("HotKeys")] pgHotKeys = 5,
	[helpcontext(0120), helpstring("Connection")] pgConnection = 6,
	[helpcontext(0120), helpstring("VoiceMail")] pgVoiceMail = 7,
	[helpcontext(0120), helpstring("CallForward")] pgCallForward = 8,
	[helpcontext(0120), helpstring("Video")] pgVideo = 9,
	[helpcontext(0120), helpstring("Advanced")] pgAdvanced = 10
};

[
	export,
	v1_enum,
	uuid("E8EA86FF-4282-4bf1-B371-EDDA7F97D5B7"),
	helpcontext(0121)
]
enum SkypeRingtone {
	[helpcontext(0121), helpstring("Ringtone")] rngRingtone = 1101,
	[helpcontext(0121), helpstring("Ringback")] rngRingback = 1102,
	[helpcontext(0121), helpstring("Busy")] rngBusy = 1103,
	[helpcontext(0121), helpstring("Dialing")] rngDialing = 1104,
	[helpcontext(0121), helpstring("Connecting")] rngConnecting = 1105,
	[helpcontext(0121), helpstring("Resume")] rngResume = 1202,
	[helpcontext(0121), helpstring("Hangup")] rngHangup = 1203,
	[helpcontext(0121), helpstring("IncomingMessage")] rngIncomingMessage = 1204,
	[helpcontext(0121), helpstring("OnlineAlert")] rngOnlineAlert = 1205
};
